import { generatePageMetadata } from "@/lib/seo/metadata"
import { ForgetPasswordForm } from "@/components/frontend/forget-password-form"
import { AuthLayout } from "@/components/frontend/auth-layout"
import type { Metadata } from "next"
import Link from "next/link"

export const metadata: Metadata = generatePageMetadata({
  title: "Forgot Password",
  description: "Reset your Teertham account password",
  path: "/forget-password",
  noIndex: true,
})

export default function ForgetPasswordPage() {
  return (
    <AuthLayout variant="forget-password">
      <article className="space-y-6">
        <header className="text-center space-y-2">
          <h1 className="text-3xl font-bold text-balance">Forgot Password?</h1>
          <p className="text-muted-foreground text-pretty">
            Enter your email address and we'll send you a verification code
          </p>
        </header>

        <section className="bg-card border rounded-xl p-6 shadow-sm space-y-6">
          <ForgetPasswordForm />

          <div className="text-center pt-4 border-t">
            <p className="text-sm text-muted-foreground">
              Remember your password?{" "}
              <Link href="/login" className="text-primary hover:underline font-medium">
                Sign In
              </Link>
            </p>
          </div>
        </section>
      </article>
    </AuthLayout>
  )
}
