import { generatePageMetadata } from "@/lib/seo/metadata"
import { OTPVerificationForm } from "@/components/frontend/otp-verification-form"
import { AuthLayout } from "@/components/frontend/auth-layout"
import type { Metadata } from "next"
import Link from "next/link"
import { redirect } from "next/navigation"
import { verifyResetFlowForOTP } from "@/lib/auth/session"

export const metadata: Metadata = generatePageMetadata({
  title: "OTP Verification",
  description: "Verify your email with the OTP code",
  path: "/otp-verification",
  noIndex: true,
})

export default async function OTPVerificationPage() {
  const { valid, email } = await verifyResetFlowForOTP()

  if (!valid || !email) {
    redirect("/forget-password")
  }

  return (
    <AuthLayout variant="otp-verification">
      <article className="space-y-6">
        <header className="text-center space-y-2">
          <h1 className="text-3xl font-bold text-balance">Verify Your Email</h1>
          <p className="text-muted-foreground text-pretty">Enter the 6-digit code we sent to your email address</p>
        </header>

        <section className="bg-card border rounded-xl p-6 shadow-sm space-y-6">
          <OTPVerificationForm email={email} />

          <div className="text-center pt-4 border-t">
            <p className="text-sm text-muted-foreground">
              Didn't receive the code?{" "}
              <Link href="/forget-password" className="text-primary hover:underline font-medium">
                Try again
              </Link>
            </p>
          </div>
        </section>
      </article>
    </AuthLayout>
  )
}
