import type { Metadata } from "next"
import { PackageFormClient } from "@/components/admin/custom-packages/package-form-client"

export const metadata: Metadata = {
  title: "Add Custom Package | Teertham",
  description: "Create a new custom tour package with multi-day itineraries and flexible pricing",
  openGraph: {
    title: "Add Custom Package | Teertham",
    description: "Create a new custom tour package with multi-day itineraries",
    type: "website",
  },
  twitter: {
    card: "summary",
    title: "Add Custom Package | Teertham",
    description: "Create a new custom tour package",
  },
}

export default function AddCustomPackagePage() {
  return (
    <main className="admin-main">
      <PackageFormClient mode="add" />
    </main>
  )
}
