import Link from "next/link"
import { Bell } from "lucide-react"
import { Button } from "@/components/ui/button"
import { AdminUserMenu } from "./admin-user-menu"

export function AdminHeaderServer() {
  return (
    <header className="sticky top-0 z-30 w-full border-b border-border/40 bg-card shadow-md">
      <div className="flex h-16 items-center gap-4 px-4 md:px-6">
        {/* Mobile menu button placeholder - actual button is in AdminMobileNav */}
        <div className="w-10 h-10 md:hidden" />

        <Link href="/admin/dashboard" className="flex items-center gap-3 font-semibold md:hidden">
          <div className="flex h-10 w-10 items-center justify-center rounded-xl bg-gradient-to-br from-primary to-primary/80 text-primary-foreground shadow-lg shadow-primary/25">
            <span className="text-lg font-bold">T</span>
          </div>
          <div className="flex items-center gap-2.5">
            <span className="text-xl font-semibold tracking-tight">Teertham</span>
            <span className="text-[10px] font-bold uppercase tracking-widest bg-gradient-to-r from-primary/20 to-primary/10 text-primary px-2.5 py-1 rounded-lg border border-primary/20">
              Admin
            </span>
          </div>
        </Link>

        <div className="ml-auto flex items-center gap-3">
          <Link href="/admin/notification">
            <Button
              variant="ghost"
              size="icon"
              className="relative rounded-xl hover:bg-muted"
              aria-label="View notifications"
            >
              <Bell className="h-5 w-5 text-muted-foreground" aria-hidden="true" />
              <span className="absolute -top-0.5 -right-0.5 flex h-5 w-5 items-center justify-center">
                <span className="absolute inline-flex h-full w-full animate-ping rounded-full bg-destructive/50 opacity-75" />
                <span className="relative inline-flex h-4 w-4 items-center justify-center rounded-full bg-destructive text-[10px] font-bold text-destructive-foreground">
                  3
                </span>
              </span>
            </Button>
          </Link>

          {/* User menu - client component reads email from cookie */}
          <AdminUserMenu />
        </div>
      </div>
    </header>
  )
}
