// Common status types
export type PackageStatus = "active" | "inactive"
export type BookingStatus = "booked" | "ongoing" | "completed" | "cancelled"
export type PaymentStatus = "pending" | "partial" | "completed" | "refunded"

// Vehicle types
export interface PackageVehicle {
  id: string
  photo: string
  vehicleName: string
  perDayPrice: number
  passengerLimit: number
}

export interface CustomPackageVehicle {
  id: string
  vehicleId: string
  vehicleName: string
  vehiclePhoto: string
  perDayPrice: number
}

// Hotel types
export interface PackageHotel {
  id: string
  photo: string
  hotelName: string
}

// Location types
export interface PackageLocation {
  id: string
  name: string
  image: string
  itineraryDescription: string
  otherDetails: string
}

// Pricing types
export interface PackagePricing {
  b2cWeekdayPerHead: number
  b2cWeekendPerHead: number
  b2bAgentPricing: number
}

// Fix Package types
export interface FixPackage {
  id: string
  name: string
  locationDetails: string
  itineraryDetails: string
  otherDetails: string
  originalPrice: number
  discountedPrice: number
  totalDays: number
  vehicles: PackageVehicle[]
  status: PackageStatus
  createdAt: string
  updatedAt: string
}

// Custom Package types
export interface DayPlan {
  dayNumber: number
  locations: PackageLocation[]
  vehicles: CustomPackageVehicle[]
  pricing: PackagePricing
}

export interface CustomPackage {
  id: string
  cityName: string
  category: "adventure" | "thrill" | "suspense" | "spiritual" | "others"
  totalLocations: number
  dayPlans: DayPlan[]
  status: PackageStatus
  createdAt: string
  updatedAt: string
}

// Spiritual Package types
export interface SpiritualDayPlan {
  dayNumber: number
  locations: PackageLocation[]
  vehicles: CustomPackageVehicle[]
  hotels: PackageHotel[]
  pricing: PackagePricing
}

export interface SpiritualPackage {
  id: string
  cityName: string
  totalLocations: number
  dayPlans: SpiritualDayPlan[]
  status: PackageStatus
  createdAt: string
  updatedAt: string
}

// Booking types
export interface BaseBooking {
  id: string
  customerId: string
  customerName: string
  customerEmail: string
  customerPhone: string
  bookingDate: string
  travelersCount: number
  startDate: string
  endDate: string
  totalDays: number
  bookingAmount: number
  advanceAmount: number
  pendingAmount: number
  status: BookingStatus
  createdAt: string
  updatedAt: string
}

export interface FixPackageBooking extends BaseBooking {
  packageId: string
  packageName: string
  location: string
  vehicleSelected: string
}

export interface CustomPackageBooking extends BaseBooking {
  packageId: string
  packageName: string
  cityName: string
  category: string
  totalLocations: number
}

export interface SpiritualPackageBooking extends BaseBooking {
  packageId: string
  packageName: string
  cityName: string
  totalLocations: number
}

export interface AgentBooking extends BaseBooking {
  agentId: string
  agentName: string
  agentEmail: string
  agentPhone: string
  packageId: string
  packageName: string
  cityName: string
  category: string
  commission: number
}

// Hotel Booking types
export interface HotelBooking {
  id: string
  hotelId: string
  hotelName: string
  ownerName: string
  ownerEmail: string
  ownerPhone: string
  customerId: string
  customerName: string
  customerEmail: string
  customerPhone: string
  roomSelected: string
  totalMembers: number
  checkInDate: string
  checkOutDate: string
  totalNights: number
  price: number
  commission: number
  status: BookingStatus
  createdAt: string
  updatedAt: string
}

// Table sorting types
export type SortDirection = "asc" | "desc"

// Statistics types
export interface PackageStats {
  total: number
  active: number
  inactive: number
  totalRevenue: number
  averagePrice: number
  averageDuration: number
}

export interface BookingStats {
  booked: number
  ongoing: number
  completed: number
  cancelled: number
  total: number
  bookedAmount: number
  ongoingAmount: number
  completedAmount: number
  totalAmount: number
  totalTravelers: number
}
